<?php

namespace App\Http\Resources\FreeMaterial;

use App\Http\Resources\Course\CourseResource;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Subject\SubjectResource;
use App\Http\Traits\ResourceHelper;

class FreeMaterialResource extends JsonResource
{
    use ResourceHelper;

    public function toArray($request): array
    {
        return [
            'id'    => $this->id,
            'type'  => $this->type,
            'title' => $this->title,
            'link'  => $this->link_url,
            'course'=> new CourseResource($this->whenLoaded('course')),
            'subject'=> new SubjectResource($this->whenLoaded('subject')),
        ];
    }
}
