<?php

namespace App\Http\Resources\Feedback;

use App\Http\Resources\User\UserResource;
use App\Http\Resources\Course\CourseResource;
use Illuminate\Http\Resources\Json\JsonResource;

class FeedbackResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id'        => $this->id,
            'user_id'   => new UserResource($this->whenLoaded('user')),
            'course_id' => new CourseResource($this->whenLoaded('course')),
            'content'   => $this->content,
            'rating'    => $this->rating,
        ];
    }
}
