<?php

namespace App\Http\Resources\Evaluation;

use App\Http\Resources\User\UserResource;
use App\Http\Resources\Lecture\LectureResource;
use App\Http\Traits\ResourceHelper;
use Illuminate\Http\Resources\Json\JsonResource;

class EvaluationResource extends JsonResource
{
    use ResourceHelper;

    public function toArray($request): array
    {
        return [
            'id'          => $this->id,
            'lecture'     => new LectureResource($this->whenLoaded('lecture')),
            'student'     => new UserResource($this->whenLoaded('student')),
            'is_attend'   => $this->whenExists($this->is_attend),
            'attendance_degree' => $this->whenExists($this->attendance_degree),
            'assignment_degree' => $this->whenExists($this->assignment_degree),
        ];
    }
}
