<?php

namespace App\Http\Resources\Course;

use App\Enums\UserType;
use App\Http\Resources\FreeMaterial\FreeMaterialResource;
use \App\Http\Traits\ResourceHelper;
use App\Http\Resources\Lecture\LectureResource;
use App\Http\Resources\Round\RoundResource;
use GPBMetadata\Google\Api\Auth;
use Illuminate\Http\Resources\Json\JsonResource;


class CourseResource extends JsonResource
{
    use ResourceHelper;

    public function toArray($request): array
    {
        return [
            'id'          => $this->id,
            'title'       => $this->title,
            'image'       => $this->whenExists($this->image),
            'price'       => $this->whenExists($this->price),
            'description' => $this->whenExists($this->description),
            'level'       => $this->whenLoaded('category', function () {
                return $this->category->name;
            }),
            'level_id'                => $this->whenExists($this->category_id),
            'sessions_count'          => $this->sessions_count,
            'duration'                => $this->duration,
            'what_you_will_learn'     => $this->what_you_will_learn,
            'learning_plan'           => $this->learning_plan,
            'preview_video'           => $this->preview_video,
            'preview_video_thumbnail' => $this->preview_video_thumbnail,
            'is_enrolled'             => $this->is_enrolled,
            'course_content'          =>$this->course_content,
            'skills'                  => $this->skills,
            'rounds_count' => $this->whenLoaded('rounds', fn() => $this->rounds->count()),
            'rounds' => RoundResource::collection($this->whenLoaded('rounds')),
            'status'                  => $this->status,
            'placement_test_available'=> $this->placement_test_available,
            'topic_id' => $this->whenLoaded('topic', fn() => $this->topic->id),
            'has_ended' => empty(auth()->user()->roundHasEnded($this->id)),
            'free_materials'=>$this->whenLoaded('free_materials', function() {
                return FreeMaterialResource::collection($this->free_materials);
            }),
        ];
    }
}
