<?php

namespace App\Http\Resources\ContactUs;

use App\Http\Resources\User\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ContactUsResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'      => $this->id,
            'user'    => UserResource::make($this->whenLoaded('user')),
            'subject' => $this->subject,
            'message' => $this->message,
            'status'  => $this->status,
        ];
    }
}
