<?php

namespace App\Http\Requests\WhatsappCampaigns;

use App\Models\User;
use App\Models\WhatsappTemplate;
use App\Http\Requests\FormRequest;


class CreateWhatsappCampaignsRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'template_id'  => ['nullable', 'integer', 'exists:whatsapp_templates,id'],
            'message'      => ['nullable', 'string'],
            'user_ids'     => ['nullable', 'array'],
            'user_ids.*'   => ['nullable',],
            'all_students' => ['nullable', 'boolean'],
            'all_users'    => ['nullable', 'boolean'],
            'round_id'     => ['nullable', 'exists:rounds,id'],
            'course_id'    => ['nullable', 'exists:courses,id'],
        ];
    }
    public function validated($key = null, $default = null)
    {
        $data                 = parent::validated();
        $data['user_ids']     = $data['user_ids'] ?? [];
        $data['all_students'] = $data['all_students'] ?? false;
        $data['all_users']    = $data['all_users'] ?? false;
        if (isset($data['all_students'])) {
            $data['notifiables'] = User::students()->get();
        }
        if (isset($data['all_users'])) {
            $data['notifiables'] = User::get();
        }
        if (isset($data['user_ids'])) {
            $data['notifiables'] = User::whereIn('id', $data['user_ids'])->get();
        }
        if(isset($data['template_id'])){
            $template = WhatsappTemplate::find($data['template_id']);
            if($template){
                $data['message'] = $template->body;
            }
        }
        return $data;
    }
}
