<?php

namespace App\Http\Requests\User;

use App\Enums\DefineStatus;
use App\Enums\UserGender;
use App\Http\Requests\FormRequest;
use Illuminate\Validation\Rule;

class CreateUserRequest extends FormRequest
{
        /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name'     => ['required', 'string', 'max:255'],
            'email'    => ['required', 'string', 'email', 'max:255', 'unique:users,email'],
            'phone'    => ['nullable', 'string', 'max:20', 'unique:users,phone'],
            'photo'    => ['nullable', 'image', 'mimes:jpeg,png,jpg,webp', 'max:2048'],
            'password' => ['required', 'string', 'min:8', 'max:255', 'confirmed'],
            'status'   => ['nullable', 'integer', Rule::in(DefineStatus::values())],
            'role_id'=>['nullable', 'integer','exists:roles,id'],
            'gender' => ['nullable', 'integer', Rule::in(UserGender::values())],
            'desc_instructor'=>['nullable', 'string', 'max:500000'],
            'assign_round'=>['nullable', 'array'],
            'skills_status'=>['nullable', 'boolean'],
        ];
    }
}
