<?php

namespace App\Http\Requests\Ticket;

use Illuminate\Foundation\Http\FormRequest;

class ReplyToTicketRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'content'        => ['nullable', 'string', 'max:5000', 'required_without:content_file'],
            'content_file'   => ['nullable', 'file','mimes:webm,wav,mp3,m4a,jpeg,png,jpg', 'max:2048', 'required_without:content'],
        ];
    }
}
