<?php

namespace App\Http\Requests\RoundStudent;

use App\Enums\UserType;
use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;

class MoveStudentRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_ids'     => ['required', 'array', 'min:1', 'exists:users,id,type,' . UserType::STUDENT->value],
            'old_round_id' => ['required', 'exists:rounds,id'],
            'new_round_id' => ['required', 'exists:rounds,id', 'different:old_round_id'],
        ];
    }
}
