<?php

namespace App\Http\Requests\Round;

use App\Enums\TypeOfRound;
use App\Models\Course;
use App\Enums\UserType;
use App\Enums\DefineStatus;
use Illuminate\Validation\Rule;
use App\Http\Requests\FormRequest;

class CreateRoundRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'name'                => ['required', 'string', 'max:255'],
            'price'               => ['nullable', 'numeric'],
            'discount'            => ['nullable', 'numeric'],
            'whatsapp_group_link' => ['nullable', 'url', 'max:255'],
            'google_meet_link'    => ['nullable', 'url', 'max:255'],
            'course_id'           => ['required', 'exists:courses,id'],
            'instructor_id'       => ['required', 'exists:users,id'],
            'status'              => ['nullable', 'integer', Rule::in(DefineStatus::values())],
            'type'                => ['nullable', 'integer', Rule::in(TypeOfRound::values())],
            'start_date'          => ['required', 'date', 'date_format:Y-m-d'],
            'end_date'            => ['nullable', 'date', 'date_format:Y-m-d'],
            'student_id'          => ['nullable','array'],
            'student_id.*'        => ['nullable','integer','exists:users,id,type,' . UserType::STUDENT->value],
            'branch_id'         =>['nullable','integer','exists:branches,id'],
            'additional_instructors' => ['nullable','array'],
            'max_student'=>['nullable','integer'],
            'weeks_count'=>['required','integer'],
            'days_count'=>['nullable','integer'],
            'day_one'=>['nullable','string','max:255'],
            'day_two'=>['nullable','string','max:255']
        ];
    }
    public function validated($key = null, $default = null){
        $dataValidated          = parent::validated();
        if (!isset($dataValidated['price'])) {
            $dataValidated['price'] = Course::where('id', $dataValidated['course_id'])->value('price');
        }
        if (isset($dataValidated['discount']) && $dataValidated['price']) {
            $dataValidated['price'] = $dataValidated['price'] - $dataValidated['discount'];
        }
        return $dataValidated;
    }
}
