<?php

namespace App\Http\Requests\Profile;

use App\Http\Requests\FormRequest;


class UpdateUserRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'name'                  => 'required|string|max:255',
            'phone'                 => 'required|string|max:255',
            'email'                 => 'required|email|unique:users,email,' . $this->user()->id,
            'password'              => 'nullable|string|min:8',
        ];
    }
}