<?php

namespace App\Http\Requests\PlacementTest;

use App\Enums\DefineStatus;
use App\Enums\QuestionType;
use Illuminate\Foundation\Http\FormRequest;

class UpdatePlacementTestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'category_id'=>'required|exists:categories,id',
            'tag_id'=>'required|exists:placement_test_tags,id',
            'question_type'=>'required|in:'.implode(',',QuestionType::values()),
            'question_content'=>'required',
            'listening_content' => 'required_if:question_type,' . QuestionType::Listening->value,
            'answer_writing'=> 'required_if:question_type,' . QuestionType::Writing->value,
            'options'=>'required|array',
            'options.*.id'=> 'required_with:options|exists:bank_options,id',
            'options.*.option_content'=>'required|string',
            'options.*.is_correct'=>'required|boolean',
            'case'                  => 'required_if:question_type,' . QuestionType::Case->value,        ];
    }
}
