<?php

namespace App\Http\Requests\Notification;

use App\Models\User;
use App\Http\Requests\FormRequest;
use App\Models\Round;

class CreateNotificationRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'message'      => ['required', 'string'],
            'title'        => ['required', 'string'],
            'user_ids'     => ['nullable', 'array'],
            'user_ids.*'   => ['nullable',],
            'all_students' => ['nullable', 'boolean'],
            'all_users'    => ['nullable', 'boolean'],
            'round_id'     => ['nullable', 'exists:rounds,id'],
            'course_id'    => ['nullable', 'exists:courses,id'],
            'type'         => ['nullable', 'integer'],
        ];
    }
    public function validated($key = null, $default = null)
    {
        $data                 = parent::validated();
        $data['user_ids']     = $data['user_ids'] ?? [];
        $data['all_students'] = $data['all_students'] ?? false;
        $data['all_users']    = $data['all_users'] ?? false;
        $round = !empty($data['round_id']) ? Round::find($data['round_id']) : null;
        $data['data'] = [
            'message'   => $data['message'] ?? null,
            'title'     => $data['title'] ?? null,
            'type'      => !empty($data['round_id']) ? "3" : ($data['type'] ?? "1"),
            'course_id' => !empty($data['course_id'])
                            ? $data['course_id']
                            : ($round ? $round->course_id : null),
            // 'round_id'  => !empty($data['course_id']) ? $data['course_id'] : null,
        ];
        unset($data['message'],$data['title']);
        if (isset($data['all_students'])) {
            $data['notifiables'] = User::students()->get();
        }
        if (isset($data['all_users'])) {
            $data['notifiables'] = User::get();
        }
        if (isset($data['user_ids'])) {
            $data['notifiables'] = User::whereIn('id', $data['user_ids'])->get();
        }
        $data['notifiable_type'] = 'App\Models\User';
        return $data;
    }
}
