<?php

namespace App\Http\Requests\Notice;

use App\Enums\FeedbackType;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class NoticeRequest extends FormRequest
{
    public function rules(): array
    {
            return [
                'round_id'     => ['required', 'exists:rounds,id'],
                'content'      => ['nullable', 'required_without:content_file'],
                'content_file' => ['nullable', 'required_without:content','file','mimes:webm,wav,mp3,m4a,jpeg,png,jpg', 'max:2048' ],
                'note'         => ['nullable', 'string', 'max:2000'],
                'type'         => ['required', 'string', Rule::in(FeedbackType::values())],
            ];
    }


    public function validated($key = null, $default = null)
    {
        $data = parent::validated();
        if ($data['type'] == FeedbackType::IMAGE->value || $data['type'] == FeedbackType::AUDIO->value) {
            $data['content'] = $data['content_file'];
            unset($data['content_file']);
        }
        return $data;
    }

}
