<?php

namespace App\Http\Requests\LectureQuestion;

use App\Enums\QuestionType;
use App\Enums\QuestionCategory;
use Illuminate\Foundation\Http\FormRequest;

class CreateLectureQuestionRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'lecture_id' => 'required|exists:lectures,id',
              // 'category'                 => 'required|in:' . implode(',', QuestionCategory::values()),
            'question_type'            => 'required|in:' . implode(',', QuestionType::values()),
            'question_content'         => 'required',
            'listening_content' => 'required_if:question_type,' . QuestionType::Listening->value,
            'answer_writing'=> 'required_if:question_type,' . QuestionType::Writing->value,
            'tag_id'=>'required|exists:placement_test_tags,id',
            'options'                  => 'required_if:question_type,' . QuestionType::Listening->value . ',' . QuestionType::Reading->value . '|array',
            'options.*.option_content' => 'required_with:options|string',
            'options.*.is_correct'     => 'required_with:options|boolean',
            // 'case_id'                  => 'required_if:question_type,' . QuestionType::Case->value . '|exists:lecture_question_cases,id',
            'case'                  => 'required_if:question_type,' . QuestionType::Case->value,

        ];
    }
    public function messages(): array
    {
        return [
            'options.*.option_content.required_with' => 'The option content field is required when options are present.',
            'options.*.is_correct.required_with'     => 'The is correct field is required when options are present.',
        ];
    }
}
