<?php

namespace App\Http\Requests\Lecture;

use App\Enums\DefineStatus;
use App\Http\Requests\FormRequest;
use Illuminate\Validation\Rule;

class UpdateLectureRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'name'               => ['required', 'string', 'max:255'],
            'url'                => ['nullable', 'url', 'max:255'],
            'start_time'         => ['nullable', 'date'],
            'week_number'        => ['nullable', 'integer', 'min:1'],
            'round_id'           => ['required', 'exists:rounds,id'],
            'status'             => ['required'],
            'meeting_start_time' => ['nullable', 'date', 'date_format:Y-m-d H:i:s','after_or_equal:now'],
            'meeting_duration'   => ['nullable', 'integer', 'min:1'],
            'files' => ['nullable', 'array'],
            'remove_files_ids' => ['nullable', 'array'],
            // 'files.*' => ['file', 'mimes:pdf'],
        ];
    }
}
