<?php

namespace App\Http\Requests\Instructor\InstructorRound;

use Illuminate\Foundation\Http\FormRequest;

class UpdateLectureTaskRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'lecture_id'       => ['required','exists:lectures,id'],
            'description'      => ['required','string'],
            'goal'             => ['nullable','string'],
            'note'             => ['nullable','string'],
            'files_included'   =>['nullable','file','mimes:pdf,doc,docx,xls,xlsx,ppt,pptx,zip,rar,img,png,bmp,jpeg,jpg,json'],
            // 'files_included'   => ['nullable','array'],
            // 'files_included.*' => ['nullable','file','mimes:pdf,doc,docx,xls,xlsx,ppt,pptx,zip,rar,img,png,bmp,jpeg,jpg,json'],
            'deadline'         => ['nullable','date'],
            'task_link'        => ['nullable','string','url'],
        ];
    }
}
