<?php

namespace App\Http\Requests\Grade;

use App\Http\Requests\FormRequest;

class GradeRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'student_id' => 'required|integer|exists:users,id',
            'lecture_id' => 'required|integer|exists:lectures,id',
            'total_questions' => 'nullable|integer|min:1',
            'correct_answers' => 'nullable|integer|min:0',
            'grade' => 'required|numeric|between:0,100'
        ];
    }
}
