<?php

namespace App\Http\Requests\Evaluation;

use App\Http\Requests\FormRequest;

class UpdateEvaluationRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'student_id'        => ['required','exists:users,id'],
            'attendance_degree' => ['nullable','numeric','min:0','max:100'],
            'assignment_degree' => ['nullable','numeric','min:0','max:100'],
        ];
    }
    public function validated($key = null, $default = null){
        $data            = parent::validated($key, $default);
        $data['user_id'] = $data['student_id'];
        unset($data['student_id']);
        return $data;
    }
}
