<?php

namespace App\Http\Requests\Enrollment;

use App\Enums\DefineStatus;
use App\Enums\UserType;
use App\Http\Requests\FormRequest;
use App\Models\User;
use Illuminate\Validation\Rule;

class CreateEnrollmentRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'total_amount' => ['required', 'numeric'],
            'remaining_amount' => ['nullable', 'numeric'],
            'user_id' => [
                'required', 
                'integer', 
                'exists:users,id,type,' . UserType::STUDENT->value,
                function ($attribute, $value, $fail) {
                    $roundId = $this->input('round_id');
                    
                    // Check if the user is a member of the round
                    $isStudentInRound = User::find($value)
                        ->studentRounds()
                        ->where('round_id', $roundId)
                        ->exists();
                    
                    if (!$isStudentInRound) {
                        $fail('The selected student is not enrolled in this round.');
                    }
                }
            ],
            'round_id' => ['required', 'integer', 'exists:rounds,id'],
            'status' => ['nullable', 'integer', Rule::in(DefineStatus::values())],
        ];
    }
}
