<?php

namespace App\Http\Requests\CourseEnrollment;

use App\Models\Coupon;
use App\Models\Course;
use Illuminate\Validation\Rule;
use App\Http\Requests\FormRequest;
use Illuminate\Support\Facades\DB;

class CreateCourseEnrollmentRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'course_id'            => 'required|exists:courses,id',
            'terms_and_conditions' => 'required|accepted',
            'coupon_code'          => [
                'nullable',
                'string',
                'max:255'
            ],
        ];
    }

    public function validated($key = null, $default = null)
    {
        $data                    = parent::validated();
        $course                  = Course::find($data['course_id']);
        $data['user_id']         = $this->user()->id;
        $data['enrollment_date'] = now()->format('Y-m-d');
        $data['total_amount']    = $course->price;
        return $data;
    }
}