<?php

namespace App\Http\Requests\Course;

use App\Http\Requests\FormRequest;
use App\Http\Requests\Course\CreateCourseRequest;
class UpdateCourseRequest extends FormRequest
{
    public function rules(): array
    {
        $createRequest = new CreateCourseRequest();
        return array_merge($createRequest->rules(), [
            'preview_video_thumbnail' => ['nullable', 'file', 'mimes:jpeg,png,jpg,webp', 'max:2048'],
            'learning_plan'           => ['nullable', 'file', 'mimes:pdf', 'max:2048'],
            'image'                   => ['nullable', 'file', 'mimes:jpeg,png,jpg,webp', 'max:2048'],
            'status'                  => ['nullable', 'integer', 'in:0,1'],
        ]);
    }
}
