<?php

namespace App\Http\Requests\Course;

use App\Http\Requests\FormRequest;

class CreateCourseRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'category_id'             => ['required', 'exists:categories,id'],
            'title'                   => ['required', 'string', 'max:255'],
            'image'                   => ['required', 'file','mimes:jpeg,png,jpg,webp', 'max:2048'],
            'price'                   => ['required', 'numeric'],
            'description'             => ['required', 'string', 'max:1000'],
            'preview_video'           => ['required'],
            'preview_video_thumbnail' => ['required', 'file', 'mimes:jpeg,png,jpg,webp', 'max:2048'],
            'sessions_count'          => ['required', 'integer'],
            'duration'                => ['required', 'integer'],
            'what_you_will_learn'     => ['required', 'array'],
            'what_you_will_learn.*'   => ['string', 'max:1000'],
            'learning_plan'           => ['nullable', 'file', 'mimes:pdf,doc,docx,jpg,png,jpeg,webp', 'max:2048'],
            'topic_id'                => 'required|exists:topics,id',
            'placement_test_available' => 'nullable|boolean',
            'skills'                  => 'nullable|array',
        ];
    }
}
