<?php

namespace App\Http\Requests\Category;

use App\Enums\DefineStatus;
use Illuminate\Validation\Rule;
use App\Http\Requests\FormRequest;

class CreateCategoryRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255', 'unique:categories,name'],
            'status' => ['nullable', 'integer', Rule::in(DefineStatus::values())],
            'order' => ['nullable', 'integer'],
        ];
    }
}
