<?php

namespace App\Http\Requests\Auth;

use App\Http\Requests\FormRequest;


class AuthWithPhoneAndNameRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'phone' => ['required', 'string', 'max:20', 'unique:users,phone', 'regex:/^(\+201|01)[0-2,5]{1}[0-9]{8}$/'],
            'name'  => ['required', 'string', 'max:255'],
        ];
    }

}
