<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetLocailzationMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Get the 'Accept-Language' header or use the default application locale
        $locale = $request->header('Accept-Language', config('app.locale'));
        // Validate or sanitize the locale if necessary
        $availableLocales = config('app.locales', ['en', 'ar']);
        if (!in_array($locale, $availableLocales)) {
            $locale = config('app.locale');
        }
        // Set the application locale
        app()->setLocale($locale);
    
        return $next($request);
    }
}
