<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\WhatsappTemplate\UpdateWhatsappTemplateRequest;
use App\Http\Requests\WhatsappTemplate\CreateWhatsappTemplateRequest;
use App\Http\Resources\WhatsappTemplate\WhatsappTemplateResource;
use App\Models\WhatsappTemplate;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class WhatsappTemplateController extends Controller
{
    public function __construct()
    {
        //
    }

    public function index(): AnonymousResourceCollection
    {
        $whatsappTemplates = WhatsappTemplate::useFilters()->dynamicPaginate();
        return WhatsappTemplateResource::collection($whatsappTemplates);
    }

    public function store(CreateWhatsappTemplateRequest $request): JsonResponse
    {
        $whatsappTemplate = WhatsappTemplate::create($request->validated());

        return $this->apiResponseStored(new WhatsappTemplateResource($whatsappTemplate));
    }

    public function show(WhatsappTemplate $whatsappTemplate): JsonResponse
    {
        return $this->apiResponseShow( new WhatsappTemplateResource($whatsappTemplate));
    }

    public function update(UpdateWhatsappTemplateRequest $request, WhatsappTemplate $whatsappTemplate): JsonResponse
    {
        $whatsappTemplate->update($request->validated());

        return $this->apiResponseUpdated(new WhatsappTemplateResource($whatsappTemplate));
    }

    public function destroy(WhatsappTemplate $whatsappTemplate): JsonResponse
    {
        $whatsappTemplate->delete();
        return $this->apiResponseDeleted();
    }

}
