<?php

namespace App\Http\Controllers\Api\V1\Student;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Skill;
class SkillController extends Controller
{
    public function index(Request $request)
    {
        $user= auth()->user();
        $skills = [
            'skills_course'=> $user->skills()->where('course_id', '!=', null)->first()?->title ?? null,
            'skills_student'=> $user->skills()->where('course_id', '=', null)->first()?->title ?? null,
        ];
        return $this->apiResponse($skills);
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|array',
        ]);

        $skill = Skill::where('course_id', '=', null)->where('user_id', $request->user()->id)->first();
        if(!$skill){
            $skill = Skill::create([
                'user_id' => $request->user()->id,
                'title' => $request->title,
                'course_id' => null,
                ]);
        }else{
            $skill->update([
                'title' => $request->title,
            ]);
        }

        return $this->apiResponseStored($skill);
    }

    public function update(Request $request, Skill $skill = null)
    {
        $request->validate([
            'title' => 'required|array',
        ]);

        if($skill){
            $skill->update([
                'title' => $request->title,
                'course_id' => $request->course_id ?? null,
            ]);
        }else{
            $skill = Skill::where('course_id', null)->where('user_id', $request->user()->id)->first();
            if(!$skill){
                $skill = Skill::create([
                    'user_id' => $request->user()->id,
                    'title' => $request->title,
                    'course_id' => null,
                ]);
            }else{
                $skill->update([
                    'title' => $request->title,
                ]);
            }
        }

        return $this->apiResponseUpdated($skill);
    }

    public function destroy(Skill $skill)
    {
        $skill->delete();
        return $this->apiResponseDeleted();
    }
}
