<?php

namespace App\Http\Controllers\Api\V1\Student;

use App\Http\Controllers\Controller;
use App\Models\Project;
use App\Http\Requests\StoreProjectRequest;
use App\Http\Requests\UpdateProjectRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ProjectController extends Controller
{
    public function index()
    {
        $projects = Auth::user()->projects()->latest()->get();
        return $this->apiResponse($projects);
    }

    public function store(StoreProjectRequest $request)
    {

        $project = Auth::user()->projects()->create($request->only([
            'title', 'description', 'link', 'video_link'
        ]));

        return $this->apiResponseStored($project);
    }

    public function show(Project $project)
    {
        return $this->apiResponse($project);
    }

    public function update(UpdateProjectRequest $request, Project $project)
    {

        $project->update($request->only([
            'title', 'description', 'link', 'video_link'
        ]));

        return $this->apiResponseUpdated($project);
    }

    public function destroy(Project $project)
    {
        $project->delete();
        return $this->apiResponseDeleted();
    }
}
