<?php
namespace App\Http\Controllers\Api\V1;

use App\Models\User;
use App\Models\Round;
use App\Models\Notification;
use App\Models\RoundStudent;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Notifications\EmailNotification;
use App\Services\Notification\NotificationService;
use App\Services\Notification\FirebaseNotificationService;
use App\Http\Resources\Notification\NotificationResource;
use App\Http\Requests\Notification\CreateNotificationRequest;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification as FacadesNotification;

class NotificationController extends Controller
{
    protected $firebaseNotificationService;

    public function __construct(
        protected NotificationService $notificationService,
        FirebaseNotificationService $firebaseNotificationService
    ) {
        $this->firebaseNotificationService = $firebaseNotificationService;
    }
    public function index()
    {
        // $notifications = Notification::with('notifiable')
        // ->latest()
        // ->distinct('created_at')
        // ->dynamicPaginate();
        $notifications=auth()->user()->notifications;
        return NotificationResource::collection($notifications);
    }
    public function getReadNotifications()
    {
        $notifications = auth()->user()->notifications()
            ->whereNotNull('read_at')
            ->latest()
            ->dynamicPaginate();

        return NotificationResource::collection($notifications);
    }

    public function getUnreadNotifications()
    {
        $notifications = auth()->user()->notifications()
            // ->whereNull('read_at')
            ->latest()
            ->dynamicPaginate();

        return NotificationResource::collection($notifications);
    }


    public function readMarkNotification(Request $request)
    {
        if ($request->filled('notification_id')) {
            $notification = auth()->user()->notifications()->find($request->notification_id);

            if ($notification && $notification->read_at === null) {
                $notification->markAsRead();
            }

            return $this->apiResponseShow([]);
        }

        auth()->user()->unreadNotifications->each->markAsRead();

        return $this->apiResponseShow([]);
    }

    public function store(CreateNotificationRequest $request)
    {
        $data = $request->validated();

        if ((isset($data['round_id']) || isset($data['course_id']))) {
            $data['notifiables'] = $this->notificationService->getNotifiablesByContext($data);
        }
        $this->notificationService->storeNotification($data['data'], $data['notifiables']);

        return $this->apiResponseShow([]);
    }
    public function sendEmailNotification(CreateNotificationRequest $request)
    {
        $data = $request->validated();

        if ((isset($data['round_id']) || isset($data['course_id']))) {
            $roundStudents = $this->notificationService->getNotifiablesByContext($data);
            $userIds = $roundStudents->pluck('user_id')->unique()->toArray();
            $notifiables = User::whereIn('id', $userIds)->get();
        } else {
            $notifiables = User::whereIn('id', $data['user_ids'])->get();
        }

        if ($notifiables->isEmpty()) {
            return $this->apiResponseFailed(__('main.notifications.errors.no_users_found'));
        }

        foreach ($notifiables as $user) {
            $user->notify(new EmailNotification($data['data']));
        }

        return $this->apiResponseShow([]);
    }

    public function sendPushNotification(CreateNotificationRequest $request)
    {
        $data = $request->validated();

        if (isset($data['round_id']) || isset($data['course_id'])) {
            $users = $this->notificationService->getNotifiablesByContext($data);
        } else {
            $users = User::whereIn('id', $data['user_ids'])->get();
        }

        if ($users->isEmpty()) {
            return $this->apiResponseFailed(__('main.notifications.errors.no_users_found'));
        }

        $userIds = $users->pluck('id')->toArray();

        $notificationData = [
            'title' => $data['data']['title'],
            'content' => $data['data']['message'],
            'type' => $data['data']['type'] ?? "1",
        ];

        $result = $this->firebaseNotificationService->sendToUsersViaFirebase($userIds, $notificationData);

        if ($result === null) {
            return $this->apiResponseFailed(__('main.notifications.errors.failed_to_send'));
        }

        $this->notificationService->storeNotification($data['data'], $users);

        return $this->apiResponseShow([]);
    }




}
