<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\NoticeStudent;
use Illuminate\Http\Request;

class NoticeStudentController extends Controller
{
    public function store(Request $request){
        $data=$request->validate([
            'user_id'=>'required|integer',
            'content'=>'required|string|max:10000'
        ]);
        $noticeStudent=NoticeStudent::create($data);
        return $this->apiResponseStored($noticeStudent);
    }
    public function update(Request $request,NoticeStudent $noticeStudent){
        $data=$request->validate([
            'user_id'=>'required|integer',
            'content'=>'required|string|max:10000'
        ]);
        $noticeStudent->update($data);
        return $this->apiResponseUpdated($noticeStudent);
    }
    public function destroy(NoticeStudent $noticeStudent){
        $noticeStudent->delete();
        return $this->apiResponseDeleted();
    }
}
