<?php

namespace App\Http\Controllers\Api\V1;

use App\Enums\FeedbackType;
use App\Http\Controllers\Controller;
use App\Http\Requests\Notice\NoticeRequest;
use App\Http\Resources\Notice\NoticeResource;
use App\Http\Traits\MediaHandler;
use App\Models\Notice;

class NoticeController extends Controller
{
    use MediaHandler;
    public function store(NoticeRequest $request)
    {
        $data = $request->validated();
        if($data['type'] == FeedbackType::IMAGE->value || $data['type'] == FeedbackType::AUDIO->value){
            $data['content'] = $this->upload($data['content'],'tasks/feedback');
        }
        $notice=Notice::create([
            'round_id' => $data['round_id'],
            'content'            => $data['content'],
            'type'               => $data['type'],
            'note'               => $data['note']??null,
        ]);
        $notice->load(['round','createdBy']);
        return $this->apiResponseUpdated(new NoticeResource($notice));
    }

    public function destroy(Notice $notice)
    {
        $notice->delete();
        if($notice->type == FeedbackType::IMAGE->value || $notice->type == FeedbackType::AUDIO->value){
            MediaHandler::deleteMedia($notice->content);
        }
        return $this->apiResponseDeleted();
    }
}
