<?php

namespace App\Http\Controllers\Api\V1;

use App\Models\LectureTask;
use App\Http\Traits\MediaHandler;
use App\Http\Controllers\Controller;
use App\Http\Resources\LectureTask\LectureTaskResource;
use App\Http\Requests\LectureTask\CreateLectureTaskRequest;
use App\Http\Requests\LectureTask\UpdateLectureTaskRequest;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class LectureTaskController extends Controller
{
    use MediaHandler;
    public function __construct()
    {
        //
    }

    public function index(): AnonymousResourceCollection
    {
        $lectureTasks = LectureTask::useFilters()->dynamicPaginate();
        return LectureTaskResource::collection($lectureTasks);
    }

    public function store(CreateLectureTaskRequest $request)
    {
        $data                   = $request->validated();
        if(!empty($data['files_included'])) {
            $data['files_included'] = $this->handleTaskFiles($data['files_included']);
        }
        $lectureTask            = LectureTask::create($data);
        return $this->apiResponseStored(new LectureTaskResource($lectureTask));
    }

    public function update(UpdateLectureTaskRequest $request, LectureTask $lectureTask)
    {
        $data = $request->validated();
        if (isset($data['files_included'])) {
            // foreach ($lectureTask->files_included as $file) {
            //     $this->deleteMedia($file['path']);
            // }
            $this->deleteMedia($data['files_included']);
            $data['files_included'] = $this->handleTaskFiles($data['files_included']);
        }
        
        $lectureTask->task_link=null;
        $lectureTask->files_included=null;
        $lectureTask->save();

        $lectureTask->update($data);
        return $this->apiResponseUpdated(new LectureTaskResource($lectureTask));
    }

    public function destroy(LectureTask $lectureTask)
    {
        if (isset($lectureTask->files_included)) {
            // foreach ($lectureTask->files_included as $file) {
            //     $this->deleteMedia($file['path']);
            // }
            $this->deleteMedia($lectureTask->files_included);
        }
        $lectureTask->delete();
        return $this->apiResponseDeleted();
    }
    public function handleTaskFiles($files)
    {
        // if (isset($files) && count($files) > 0) {
        //     $processedFiles = [];
        //     foreach ($files as $file) {
        //         $processedFiles[] = [
        //             'ext'  => $file->getClientOriginalExtension(),
        //             'path' => $this->upload($file, 'lecture-tasks')
        //         ];
        //     }
        // }
        return $this->upload($files, 'lecture-tasks');
    }
}
