<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Resources\LectureAnswer\LectureAnswerResource;
use App\Http\Resources\User\UserResource;
use App\Models\Lecture;
use App\Models\StudentAnswer;
use App\Models\User;
use Illuminate\Http\Request;

class LectureAnswerController extends Controller
{
    // public function index(Lecture $lecture,$user_id){
    //     $answers=StudentAnswer::where('student_id',$user_id)->where('Lecture_id',$lecture->id)->with(['student', 'lecture', 'question','option'])->useFilters()->dynamicPaginate();
    //     return LectureAnswerResource::collection($answers);
    // }
    public function studentAnswered(Lecture $lecture)
    {
        $studentIds = StudentAnswer::where('lecture_id', $lecture->id)
            ->distinct()
            ->pluck('student_id');

        $students = User::whereIn('id', $studentIds)->dynamicPaginate();

        return UserResource::collection($students);
    }
    public function index(Lecture $lecture,$user_id){
        $answers=StudentAnswer::where('student_id',$user_id)->where('Lecture_id',$lecture->id)->with(['student', 'lecture', 'question','option','question.options'])->get();
        return LectureAnswerResource::collection($answers);
    }
    public function destroy(StudentAnswer $answer){
        $answer->delete();
        return $this->apiResponseDeleted();
    }
    public function destroyForStudent($studentId)
    {
        StudentAnswer::where('student_id', $studentId)->delete();
        return $this->apiResponseDeleted();
    }

    public function destroyAll($lectureId)
    {
        StudentAnswer::where('lecture_id', $lectureId)->delete();
        return $this->apiResponseDeleted();
    }
}
