<?php

namespace App\Http\Controllers\Api\V1\Instructor;

use App\Http\Controllers\Controller;
use App\Http\Requests\Instructor\InstructorProfile\UpdateInstructorProfileRequest;
use App\Http\Resources\User\UserResource;
use App\Http\Traits\MediaHandler;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Hash;


class InstructorProfileController extends Controller
{
    use MediaHandler;

    public function showProfile(): JsonResponse
    {
        $instructor = auth()->user();
        return $this->apiResponseShow(new UserResource($instructor));
    }

    /**
     * Update authenticated student's profile.
     *
     * Validates and updates profile data, including password and photo.
     *
     * @param  UpdateStudentProfileRequest  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateProfile(UpdateInstructorProfileRequest $request): JsonResponse
    {
        $instructor = auth()->user();
        $data = $request->validated();

        // Handle password update
        if (!empty($data['password'])) {
            $data['password'] = Hash::make($data['password']);
        }

        $data['photo'] = $request->hasFile('photo')
            ? MediaHandler::updateMedia($request->file('photo'), 'instructor/photos', $instructor->photo_path)
            : $instructor->photo;

        $instructor->update($data);
        return $this->apiResponseUpdated(new UserResource($instructor));
    }

}
