<?php

namespace App\Http\Controllers\Api\V1\Instructor;

use App\Enums\UserType;
use App\Http\Controllers\Controller;
use App\Http\Requests\Instructor\InstructorAuth\InstructorLoginRequest;
use App\Services\UserAuthService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class InstructorAuthController extends Controller
{
    protected UserAuthService $authService;

    public function __construct(UserAuthService $authService)
    {
        $this->authService = $authService;
    }

    public function login(InstructorLoginRequest $request): JsonResponse
    {
        return $this->authService->login($request->email, $request->password, UserType::INSTRUCTOR);
    }

    public function logout(Request $request): JsonResponse
    {
        return $this->authService->logout($request->user());
    }
}
