<?php

namespace App\Http\Controllers\Api\V1;
use App\Http\Controllers\Controller;
use App\Http\Resources\FreeMaterial\FreeMaterialResource;
use App\Http\Traits\ApiResponse;
use App\Http\Traits\MediaHandler;
use App\Models\FreeMaterial;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class FreeMaterialController extends Controller {
    use ApiResponse, MediaHandler;
    public function index(Request $request)
    {
        $freeMaterials = FreeMaterial::with(['course:id,title', 'subject:id,name'])->paginate();
        return FreeMaterialResource::collection($freeMaterials);
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'type' => 'required|in:video,pdf',
            'title' => 'required',
            'link' => 'required',
            'course_id' => 'nullable|exists:courses,id',
            'subject_id' => 'nullable|exists:subjects,id',
        ]);

        // No need for redundant assignments as the values are already in $data

        $freeMaterial = FreeMaterial::create($data);

        if ($data['type'] === 'pdf') {
            $freeMaterial->link = $this->upload($data['link'], 'free-material');
            $freeMaterial->save();
        }

        return $this->apiResponseStored(new FreeMaterialResource($freeMaterial->load('course', 'subject')));
    }

    // public function show(FreeMaterial $freeMaterial)
    // {
    //     return new FreeMaterialResource($freeMaterial);
    // }

    public function update(Request $request, FreeMaterial $freeMaterial)
    {
        $data = $request->validate([
            'type' => 'required|in:video,pdf',
            'title' => 'required',
            'link' => 'required',
            'course_id' => 'nullable|exists:courses,id',
            'subject_id' => 'nullable|exists:subjects,id',
        ]);

        // Handle file upload if type is pdf and file is being updated
        if ($data['type'] === 'pdf' && $freeMaterial->type !== 'pdf') {
            $data['link'] = $this->upload($data['link'], 'free-material');
        }

        $freeMaterial->update($data);
        return $this->apiResponseUpdated(new FreeMaterialResource($freeMaterial->load('course', 'subject')));
    }

    public function destroy(FreeMaterial $freeMaterial)
    {
        $freeMaterial->delete();
        $freeMaterial->link =='pdf' ? $this->deleteMedia($freeMaterial->link_path) : null;
        return $this->apiResponseDeleted();
    }
}
