<?php

namespace App\Http\Controllers\Api\V1;

use App\Models\Feedback;
use App\Models\TaskFeedback;
use App\Http\Resources\TaskFeedback\TaskFeedbackResource;
use App\Http\Controllers\Controller;
use App\Http\Resources\Feedback\FeedbackResource;
class FeedbackController extends Controller
{
    public function index()
    {
        $feedbacks = Feedback::useFilters()->with('user', 'course')->dynamicPaginate();
        return FeedbackResource::collection($feedbacks);
    }


    public function taskFeedbacks(){
        $feedbacks=TaskFeedback::useFilters()->with('createdBy','lecture','taskSubmission.user')->dynamicPaginate();
        return TaskFeedbackResource::collection($feedbacks);
    }

}
