<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\Faq\UpdateFaqRequest;
use App\Http\Requests\Faq\CreateFaqRequest;
use App\Http\Resources\Faq\FaqResource;
use App\Models\Faq;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class FaqController extends Controller
{

    public function index(): AnonymousResourceCollection
    {
        $faqs = Faq::useFilters()
        ->latest()
        ->dynamicPaginate();
        return FaqResource::collection($faqs);
    }

    public function store(CreateFaqRequest $request): JsonResponse
    {
        $faq = Faq::create($request->validated());
        $faq->refresh();
        return $this->apiResponseStored(new FaqResource($faq));
    }

    public function show(Faq $faq): JsonResponse
    {
        return $this->apiResponseShow(new FaqResource($faq));
    }

    public function update(UpdateFaqRequest $request, Faq $faq): JsonResponse
    {
        $faq->update($request->validated());
        $faq->refresh();
        return $this->apiResponseUpdated(new FaqResource($faq));
    }

    public function destroy(Faq $faq): JsonResponse
    {
        $faq->delete();
        return $this->apiResponseDeleted();
    }
}
