<?php


namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Http\Controllers\Controller;
use App\Http\Resources\Course\CourseResource;
use App\Http\Resources\FreeMaterial\FreeMaterialResource;
use App\Http\Resources\Topic\TopicResource;
use App\Models\Course;
use App\Models\FreeMaterial;
use App\Models\Topic;

class TopicController extends Controller
{
    public function index(){
        $topics=Topic::all();
        return $this->apiResponse(TopicResource::collection($topics));
    }
    public function courses(Topic $topic){
        $courses= $topic->courses;
        return $this->apiResponse(CourseResource::collection($courses));
    }
    public function freeMaterials(){
        $freeMaterials=FreeMaterial::all();
        return $this->apiResponse(FreeMaterialResource::collection($freeMaterials));
    }
}
