<?php

namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Enums\UserType;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class SocialController extends Controller
{
    public function google(Request $request)
    {
        $request->validate([
            'client_id' => 'required|string',
            'email'     => 'required|email',
            'name'      => 'required|string',
            'type'      => 'required|string|in:google,apple', 
            'device_token'=>'required|string'
        ]);

        $clientId = $request->client_id;
        $email = $request->email;
        $name = $request->name;
        $type = $request->type;
        $deviceToken = $request->device_token;

        $user = User::where('email', $email)->first();

        if (!$user) {
            $user = User::create([
                'name'      => $name,
                'email'     => $email,
                'google_id' => $type === 'google' ? $clientId : null,
                'apple_id'  => $type === 'apple'  ? $clientId : null,
                'password'  => Hash::make(Str::random(16)),
                'device_token'=>$deviceToken,
                'type'  => UserType::STUDENT->value
            ]);
        } else {
            $updateData = ['device_token' => $deviceToken];

            if ($type === 'google' && !$user->google_id) {
                $updateData['google_id'] = $clientId;
            } elseif ($type === 'apple' && !$user->apple_id) {
                $updateData['apple_id'] = $clientId;
            }

            $user->update($updateData);
        }

        $token = $user->createToken('auth_token')->plainTextToken;

        return $this->apiResponse([
            'status' => 'success',
            'token'=>$token,
            'user' => $user,
        ]);
    }
}