<?php

namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Http\Controllers\Controller;
use App\Http\Resources\Review\ReviewResource;
use App\Http\Traits\ApiResponse;
use App\Models\Review;
use Illuminate\Http\Request;

class ReviewController extends Controller
{
    use ApiResponse;
    public function index(){
        $reviews=Review::where('user_id',auth()->user()->id)->with('lecture','user')->get();
        return $this->apiResponse(ReviewResource::collection($reviews));
    }
    public function show($id){
        $reviews=Review::where('lecture_id',$id)->with('lecture','user')->dynamicPaginate();
        return ReviewResource::collection($reviews);
    }
    public function destroy(Review $review){
        $review->delete();
        return $this->apiResponseDeleted();
    }
    public function store(Request $request)
    {
        $validated = $request->validate([
            'lecture_id'  => 'required|exists:lectures,id',
            'rating'      => 'nullable|integer|min:1|max:5',
            'comment'     => 'required|string',
        ]);

        $validated['user_id'] = auth()->user()->id;

        $review=Review::create($validated);

        return $this->apiResponseStored(new ReviewResource($review));
    }

    public function update(Request $request, Review $review)
    {
        $validated = $request->validate([
            'lecture_id'  => 'required|exists:lectures,id',
            'rating'      => 'nullable|integer|min:1|max:5',
            'comment'     => 'required|string',
        ]);

        $validated['user_id'] = auth()->user()->id;

        $review->update($validated);

        return $this->apiResponseUpdated(new ReviewResource($review));
    }
}
