<?php
namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Http\Controllers\Controller;
use App\Http\Resources\User\UserResource;
use App\Http\Requests\Profile\UpdateUserRequest;

class ProfileController extends Controller
{
    public function show(){ 
        $user = auth()->user();
        return $this->apiResponseShow(
            new UserResource($user),
        );
    }

    public function update(UpdateUserRequest $request){
        $user = auth()->user();
        $user->update($request->validated());
        return $this->apiResponseUpdated(
            new UserResource($user),
        );
    }
}