<?php

namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Http\Controllers\Controller;
use App\Http\Resources\LecturerLog\LecturerLogResource;
use App\Http\Traits\ApiResponse;
use App\Models\LecturerLog;
use Illuminate\Http\Request;

class LecturerLogController extends Controller
{
    use ApiResponse;
    public function store(Request $request){
       $data = $request->validate([
            'lecture_id' => 'required|exists:lectures,id',
            'user_id' => 'nullable|exists:users,id',
            'course_id' => 'required|exists:courses,id',
            'action' => 'nullable|string',
            'description' => 'nullable|string',
        ]);
        $data['user_id'] = $request->user()['id'];
        $lecturerLog=LecturerLog::create($data);
        return $this->apiResponseStored(new LecturerLogResource($lecturerLog));
    }
}
