<?php

namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Http\Resources\Coupon\CouponResource;
use App\Http\Traits\NotificationTrait;
use App\Models\Coupon;
use App\Models\Course;
use Illuminate\Http\Request;
use App\Models\CourseEnrollment;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Services\CourseEnrollmentService;
use App\Interfaces\PaymentGatewayInterface;
use App\Http\Requests\CourseEnrollment\CreateCourseEnrollmentRequest;


class CourseEnrollmentController extends Controller
{
    use NotificationTrait;
    public function __construct(
        protected CourseEnrollmentService $enrollmentService
    ) {}

    public function enroll(CreateCourseEnrollmentRequest $request)
    {
        try {
            $data = $request->validated();
            $result = $this->enrollmentService->handleEnrollment($data, Auth::id());
            $this->sendPushNotificationClientSide('client_side', 'enrollment');
            return $this->apiResponse(
                $result['data'],
                $result['message'],
                200
            );
        } catch (\Exception $e) {
            return $this->apiResponse([], $e->getMessage(), 400);
        }
    }


    public function checkCoupon(Request $request)
    {
        $coupon = Coupon::where('code', $request->coupon_code)
            ->where('status', true)
            ->where('end_date', '>', now())
            ->whereRaw('uses < max_uses')
            ->first();
        if (!$coupon) {
            return $this->apiResponse([], __('main.invalid_coupon'), 400);
        }
        return $this->apiResponse(
            [
                'code' => $coupon->code,
                'type' => $coupon->type,
                'discount_percentage' => $coupon->discount_percentage,
            ],
            __('main.coupon_applied_successfully'),
            200
        );
    }
}
