<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Resources\Branche\BrancheResource;
use App\Models\Branche;
use Illuminate\Http\Request;

class BrancheController extends Controller
{

    public function index(){
        $branches = Branche::dynamicPaginate();
        return BrancheResource::collection($branches);
    }
    public function store(Request $request){
        $data=$request->validate([
            'name'=>'required',
            'address'=>'nullable'
        ]);
        $branche = Branche::create($data);
        return $this->apiResponseStored(new BrancheResource($branche));
    }
    public function show(Branche $branche){
        return $this->apiResponseShow(new BrancheResource($branche));
    }
    public function update(Request $request, Branche $branch){
        $data=$request->validate([
            'name'=>'required',
            'address'=>'nullable'
        ]);
        $branch->update($data);
        return $this->apiResponseUpdated(new BrancheResource($branch));
    }
    public function destroy(Branche $branch){
        $branch->delete();
        return $this->apiResponseDeleted();
    }
}
