<?php

namespace App\Filters;

use App\Enums\TicketStatus;
use Essa\APIToolKit\Filters\QueryFilters;

class TicketFilters extends QueryFilters
{
    protected array $allowedFilters = ['status'];

    protected array $columnSearch = [];

    public function status($status)
    {
        if (in_array($status, TicketStatus::values(), true)) {
            $this->builder->where('status', $status);
        }
    }
}
