<?php

namespace App\Filters;

use Essa\APIToolKit\Filters\QueryFilters;

class PlacementTestResultFilters extends QueryFilters
{
    protected array $allowedFilters = [];

    protected array $columnSearch = [];
    protected array $relationSearch = [
        'user' => ['name','email','phone']
    ];

    public function phone($value){
        return $this->builder->whereHas('user', function ($query) use ($value) {
            $query->where('phone', 'like', "%$value%");
        });
    }
}
