<?php
namespace App\Filters;

use Essa\APIToolKit\Filters\QueryFilters;

class NoticeAbsentFilters extends QueryFilters
{
    protected array $allowedFilters = [
        'lecture_id',
        'student_id',
    ];

    protected array $columnSearch = [];

    public function lecture_id($term)
    {
        return $this->builder->where('lecture_id', $term);
    }

    public function student_id($term)
    {
        return $this->builder->where('student_id', $term);
    }
    public function student_name($term)
    {
        return $this->builder->whereHas('student', function ($query) use ($term) {
            $query->where('name', 'like', "%{$term}%");
        });
    }
    public function read($term)
    {
        return $this->builder->where('read', $term);
    }

    public function round_id($term)
    {
        return $this->builder->whereHas('lecture', function ($query) use ($term) {
            $query->where('round_id', $term);
        });
    }

    public function from_date($term){
        return $this->builder->whereDate('created_at','>=', $term);
    }

    public function to_date($term){
        return $this->builder->whereDate('created_at','<=', $term);
    }
}
