<?php

namespace App\Filters;

use Essa\APIToolKit\Filters\QueryFilters;

class CourseEnrollmentFilters extends QueryFilters
{
    protected array $allowedFilters = [];

    protected array $columnSearch = [];

    public function payment_status($term)
    {
        $this->builder->where('payment_status', $term);
    }


    public function from_date($term)
    {
        $this->builder->whereDate('enrollment_date', '>=', $term);
    }

    public function to_date($term)
    {
        $this->builder->whereDate('enrollment_date', '<=', $term);
    }
}
